{******************************************************************************
 ******************************************************************************
 *
 *
 *  EZ-KIT Lite resident monitor
 *
 *  This file is part of the ADSP 2181 EZ-KIT Lite resident monitor.
 *
 *  The monitor is loaded from the on-board EPROM through the BDMA
 *  interface during power up.
 *
 *  The complete source codes include the following files:
 *
 *  INTVEC  .DSP : interrupt vector table
 *  UART    .DSP : UART simulation routine
 *  MAIN    .DSP : main module
 *  SELFTEST.DSP : power up self test routine
 *  UTILITY .DSP : send a line of ASCII text through serial line
 *  COMMAND .DSP : command loop and command interpreter
 *  CODEC   .DSP : 1847 codec initialization and interrupt handling
 *
 *  TONE    .DAT : 32 samples of one complete cycle sine wave
 *  CONSTANT.K   : constants
 *
 *
 ******************************************************************************
 ******************************************************************************}










.module/ram       MAIN1;


.include    <constant.k>;



.var/dm/ram signon [81];

.init signon:
'T','h','e','r','e',' ','i','s',' ','n','o',' ','s','a','n','c',

't','u','a','r','y','!',0,' ',' ',' ',' ','e','v','i','c','e',

's',' ','A','D','S','P','-','2','1','8','1',' ','E','Z','-','K',

'I','T',' ','L','I','T','E',' ','!','!','!',' ',' ',' ',' ',' ',

' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',0;
{               !!! Analog Devices ADSP-2181 EZ-KIT LITE !!!     }




.entry  start;




{******************************************************************************
 *
 *  These codes are executed immediately after reset.
 *
 *  After a few registers are set the self test routine is called, which in
 *  turn calls codec initialization routines.  Then the UART simulation
 *  initialization routine and UART start routine are called.  At last it
 *  beeps and send 8 lines of ASCII text to the UART port, save the interrupt
 *  vectors and jumps to the command parser.
 *
 *  REGISTER USAGE SUMMARY:
 *
 *  input  :
 *  modyfy :
 *  output :
 *  destroy:
 *  keep   : i5, m5, l5, i6, l6 (codec auto-buffering)
 *  memory :
 *  calls  :
 *
 ******************************************************************************}

start:
        imask = b#0000000000;
            {     |||||||||+ | timer
                  ||||||||+- | SPORT1 rec or IRQ0
                  |||||||+-- | SPORT1 trx or IRQ1
                  ||||||+--- | BDMA
                  |||||+---- | IRQE
                  ||||+----- | SPORT0 rec
                  |||+------ | SPORT0 trx
                  ||+------- | IRQL0
                  |+-------- | IRQL1
                  +--------- | IRQ2
            }


        icntl = b#00010;
            {     ||||+- | IRQ0: 0=level, 1=edge
                  |||+-- | IRQ1: 0=level, 1=edge
                  ||+--- | IRQ2: 0=level, 1=edge
                  |+---- 0
                  +----- | IRQ nesting: 0=disabled, 1=enabled
            }


        mstat = b#1000000;
            {     ||||||+- | Data register bank select
                  |||||+-- | FFT bit reverse mode (DAG1)
                  ||||+--- | ALU overflow latch mode, 1=sticky
                  |||+---- | AR saturation mode, 1=saturate, 0=wrap
                  ||+----- | MAC result, 0=fractional, 1=integer
                  |+------ | timer enable
                  +------- | GO MODE
            }

        ax0 = b#0000000000000000;   dm (System_Control_Reg) = ax0;
            {   +-/!||+-----/+-/- | program memory wait states
                |  !|||           | 0
                |  !|||           |
                |  !||+---------- 0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !|+----------- SPORT1 1=serial, 0=FI, FO, IRQ0, IRQ1, SCLK
                |  !+------------ SPORT1 1=enabled, 0=disabled
                |  +============= SPORT0 1=enabled, 0=disabled
                +---------------- 0
                                  0
                                  0
            }

{============== S E L F T E S T ============================================}
        call selftest;              { self test }

        call init_uart;             { intialize uart routine }
        call turn_rx_on;            { turn on uart }


{============== S I G N O N   B A N N E R ==================================}
        ar = BEEP_1000_mS;                { beep }
        dm (codecBeep) = ar;

        cntr = 1;
        do lbl1 until ce;
        i7 = ^signon;
        call sendLine;              { send line to host }
lbl1:   nop;


{   save 00..2f to locations in monitor.  PC program will take care to
    re-direct download 00..2f to this buffer.  Go command will copy this
    to 00..2f before transferring control. }
        i4 = 0;
        l4 = 0;
        i7 = ^intsVec;
        cntr = 0x30;
        do usrVec until ce;
        ar = pm (i4, m7);           { px implicit }
usrVec: pm (i7, m7) = ar;

        jump cmdProc;


.endmod;
