{******************************************************************************
 ******************************************************************************
 *
 *
 *  EZ-KIT Lite resident monitor
 *
 *  This file is part of the ADSP 2181 EZ-KIT Lite resident monitor.
 *
 *  The monitor is loaded from the on-board EPROM through the BDMA
 *  interface during power up.
 *
 *  The complete source codes include the following files:
 *
 *  INTVEC  .DSP : interrupt vector table
 *  UART    .DSP : UART simulation routine
 *  MAIN    .DSP : main module
 *  SELFTEST.DSP : power up self test routine
 *  UTILITY .DSP : send a line of ASCII text through serial line
 *  COMMAND .DSP : command loop and command interpreter
 *  CODEC   .DSP : 1847 codec initialization and interrupt handling
 *
 *  TONE    .DAT : 32 samples of one complete cycle sine wave
 *  CONSTANT.K   : constants
 *
 *
 ******************************************************************************
 ******************************************************************************}










.module/ram/abs=0 MAIN;


.include    <constant.k>;


.external start;

{******************************************************************************
 *
 *
 *  This code will be placed in 0x0000..0x002f, the interrupt vectors area.
 *
 *
 ******************************************************************************}

        jump start;          rti; rti; rti;     {00: reset }
        rti;                 rti; rti; rti;     {04: IRQ2 }
        rti;                 rti; rti; rti;     {08: IRQL1 }
        rti;                 rti; rti; rti;     {0c: IRQL0 }
        ar = dm(stat_flag);                     {10: SPORT0 tx }
        ar = pass ar; if eq rti; jump next_cmd;
        jump input_samples;  rti; rti; rti;     {14: SPORT1 rx }
        rti;                 rti; rti; rti;     {18: IRQE }
        rti;                 rti; rti; rti;     {1c: BDMA }
        jump irq1isr;        rti; rti; rti;     {20: SPORT1 tx or IRQ1 }
        rti;                 rti; rti; rti;     {24: SPORT1 rx or IRQ0 }
        jump process_a_bit;  rti; rti; rti;     {28: timer }
        rti;                 rti; rti; rti;     {2c: power down }



.endmod;
