/**************************************************
 * This is all of the code to upload a .EXE file  *
 * into the 2181 through the boot monitor         *
 **************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include "upload.h"
#include "exe2dfs.h"

unsigned int hi_start,lo_start,hi_len,lo_len,hi,mi,lo;

extern segment_data[16384];
extern segment_data_pos;

int upload(void)
{
	char filename[80],buf[80];
	FILE *fi;
	int i;
	int done=0;
	int state=0;
	int datawords=0;
	int getaddress=0;

	char initstring[4];
	char endstring[4];
	char prgaddrstring[4]="@PA";
	char dataaddrstring[4]="@DA";

	initstring[0]=27;
	initstring[1]=27;
	initstring[2]='i';
	initstring[3]=0;

	endstring[0]=27;
	endstring[1]=27;
	endstring[2]='o';
	endstring[3]=0;

	printf("Enter filename:");gets(filename);

	fi=fopen(filename,"rb");
	if(fi==NULL)
	{
		printf("couldn't open %s.\n",filename);
		return(0);
	}



	do
	{
		/* Read a line from the file */
		fgets(buf,75,fi);

		switch(state)
		{


			case 0:// initial state ------------------------------------
			if(!strncmp(buf,initstring,3))
			{
				printf("initstring found.\n");
				state=1;
			} else
			{
				printf("%s is not a DSP exectuable.\n",filename);
				done=1;
			}
			break;


			case 1:// looking for segment header -----------------------
			if(!strncmp(buf,prgaddrstring,3))
			{
				printf("prg segment found.  ");
				segment_data_pos=0;
				datawords=0;
				getaddress=1;
				state=2;
			} else
			if(!strncmp(buf,dataaddrstring,3))
			{
				printf("data segment found.  ");
				segment_data_pos=0;
				datawords=0;
				getaddress=1;
				state=3;
			} else
			if(!strncmp(buf,endstring,3))
			{
				printf("endstring found.\n");
				done=1;
			} else
			{
				for(i=0;i<strlen(buf);i++)printf("%d ",buf[i]);
				printf("No recognizeable segment header found!\n");
				done=1;
			}
			break;


			case 2:// loading prg words ---------------------------
			if(buf[0]=='#')
			{
				printf("P segment end.  %d words.\n",datawords);
				while(transmit_segment(3,datawords)==0);
				state=1;
			} else
			{
				// if this is the first entry, read address bytes
				if(getaddress==1)
				{ // read two bytes
					hi_start=conv_from_hex(buf[0],buf[1]);
					lo_start=conv_from_hex(buf[2],buf[3]);
					getaddress=0;
				}
				else
				{ // read three bytes
					read_and_conv(buf,3);
					datawords++;
				}
			}
			break;


			case 3:// loading data words -------------------------
			if(buf[0]=='#')
			{
				printf("Data segment end.  %d words.\n",datawords);
				while(transmit_segment(2,datawords)==0);
				state=1;
			} else
			{
				// if this is the first entry, read address bytes
				if(getaddress==1)// read two bytes
				{
					hi_start=conv_from_hex(buf[0],buf[1]);
					lo_start=conv_from_hex(buf[2],buf[3]);
					getaddress=0;
				}
				else
				{ // read two bytes
					read_and_conv(buf,2);
					datawords++;
				}
			}
			break;


		}

	} while(!done);


	fclose(fi);
	printf("File transfer complete and successful.\n");
	return(1);
}

void read_and_conv(char *buf, int len)
{
	int i,j=0;
	unsigned char;
	int value;

	for(i=0;i<len;i++,j+=2)
	{
		value=conv_from_hex(buf[j],buf[j+1]);
		segment_data[segment_data_pos++]=value;
	}
}

unsigned char conv_from_hex(char a,char b)
{
	return((hex_to_int(a)*16) + hex_to_int(b));
}

int hex_to_int(char x)
{
	x=toupper(x);

	if( x>= '0' && x<= '9') return(x-'0');
	return(10+(x-'A'));
}


int transmit_segment(int len,int datawords)
{
	unsigned char tempstr[80];
	char checksum[80],trash;
	int i=0,j,k=0,l,m;
	int t,u;
	unsigned char hisum=0,misum=0,losum=0;
	char alive_string[80]={"$OK"};

	hi_len = datawords/256;
	lo_len = datawords%256;

	// Generate Initial String
	tempstr[i++]='$';
	tempstr[i++]='D';

	if(len==2)tempstr[i++]='D';
	if(len==3)tempstr[i++]='P';

	tempstr[i++]=hi_start;
	tempstr[i++]=lo_start;

	tempstr[i++]=hi_len;
	tempstr[i++]=lo_len;

	tempstr[i]='\0';

	printf("serial_out:");
	for(m=0;m<i;m++)
	{
		uputc(tempstr[m]);
		printf("%02x ",tempstr[m]);
	}
	ugetc(&trash);

	printf("\n");

	// Data Section
	for(j=0;j<datawords;j++)
	{
		i=0;

		for(l=0;l<len;l++)tempstr[i++]=segment_data[k++];
		tempstr[i]='\0';

		printf("serial_out:");
		for(m=0;m<i;m++)
		{
			uputc(tempstr[m]);
			printf("%02x ",tempstr[m]);
		}
		printf("\n");
	}

	// Read back checksum
	printf("checksum: ");
	if(serial_in(checksum,len)==0)
	{
		printf("serial_in failed....re-transmitting segment.\n");
		sleep(1);
		return(0);
	}

	for(m=0;m<len;m++)
	{
	 printf("%02x ",checksum[m]);
	}
	printf("\n");


	// alive inquiry
	for(l=0;l<strlen(alive_string);l++)
	{
		uputc(tempstr[l]);
	}
	printf("alive inquiry: \n");
	if(serial_in(checksum,1)==0)
	{
		printf("serial_in failed....re-transmitting segment.\n");
		sleep(1);
		return(0);
	}

	for(m=0;m<6;m++)
	{
	 printf("%02x ",checksum[m]);
	}
	printf("\n");
	return(1);
}
