#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "super.h"
#include "flashfnc.h"

/* function prototypes */
void interrupt comm_new(void);

/* global data */
unsigned comm_seg,comm_off;
unsigned asc_in=0,asc_out=0;
unsigned char buffer[800];

int main (void){
  char wang[80];
  int done=0,key;

  menu();
  return 0;
}

void comm_unin(void){
	asm{
    in al,pic_mask
    or al,int_mask
    out pic_mask,al

		push ds
    mov dx,comm_off
    mov ds,comm_seg
    mov ah,0x25
    mov al,comm_int
    int 0x21
		pop ds
	}
}

void interrupt comm_new(void){
	asm{
		cli

		mov ax,seg buffer
		mov ds,ax

		mov dx,comm_data							 /* read character from UART inp. buffer */
		in al,dx

		/* now buffer it */
		mov cx,asc_in		/* the size */
		mov bx,offset buffer
		add bx,cx
		mov [bx],al
		inc cx
		and cx,0x000f
		mov asc_in,cx

		mov al,0x20
		out 0x20,al              /* signal the interrupt controller */

		sti
	}
}

void comm_inst(void){
	char buffer[80];


	asm{
		mov cx,7                    /* blow away comm_data? why? */
		mov dx,comm_data
		mov al,0
	}
destruct:
  asm{
    out dx,al
    nop
    nop
    nop
		inc dx
    loop destruct

		mov ah,0x35                 /* get old interrupt vector */
		mov al,comm_int
		int 0x21
		mov comm_seg,es
		mov comm_off,bx

		mov dx,comm_lcr             /* need to set bit 7 to 1  */
		mov al,0x80                 /* to set baud rate */
		out dx,al
		nop
		nop
		nop

		mov dx,comm_brl              /* set the baud rates */
		mov al,0x0c									 /* c = 9600 */
		out dx,al
		nop
		nop
		nop

		mov dx,comm_brh
		mov al,0x00
		out dx,al
		nop
		nop
		nop

		mov dx,comm_lcr             /* set bit 7 back to 0 */
		mov al,0x03                 /* also 8,N,1 operation */
		out dx,al
		nop
		nop
		nop

		mov dx,comm_mcr             /* modem control register */
		mov al,0xb
		out dx,al
		nop
		nop
		nop

		mov dx,comm_ier             /* interrupt enable */
		mov al,0x1
		out dx,al
		nop
		nop
		nop

		in al,pic_mask
		and al,not int_mask
		out pic_mask,al
		nop
		nop
		nop

		mov al,comm_int
		mov dx,offset comm_new      /* & set new interrupt handler */
		mov bx,seg comm_new
		push ds
		mov ds,bx
		mov ah,0x25
		int 0x21
		pop ds
	}
}

void send(char *string){
  int coun,l;
  char byte;
  l=strlen(string);
  for(coun=0;coun<l;coun++){
    nfy:
		asm{
			mov dx,comm_stat
			in al,dx
			and al,0x20
			jz nfy
			mov bx,string
			add bx,coun
			mov al,[bx]
			mov dx,comm_data
			out dx,al
		}
	}
}

void uputc(unsigned char zz)
{
	nry:
	asm{
		mov dx,comm_stat
		in al,dx
		and al,0x20
		jz nry

		mov al,zz
		mov dx,comm_data
		out dx,al
	}
}

int recv_data(unsigned char *ret_data,int len)
{
	int j,k,l;
	unsigned char ch;
	int out_pos=0;

	for(j=0,k=0,l=0;j<len;j++)
	{
		while(asc_in==asc_out)
		{
			k++;
			if(k>30000)
			{
				l++;
				k=0;
				if(l>1000)
				{
					printf("recv timeout.\n");
					return(0);
				}
			}
		}
		ch=buffer[asc_out];
		ret_data[j]=ch;
		printf("[0x%02x] '%c'",ch,ch);
		out_pos++;if(out_pos==8){out_pos=0;printf("\n");}

		asc_out=asc_out+1;if (asc_out>15)asc_out=0;
	}
	return(1);
}

void empty_recv_buffer(void)
{
	unsigned char ch,ch2;

	while(asc_in!=asc_out)
	{
		asc_out=asc_out+1;if (asc_out>15)asc_out=0;
		ch=buffer[asc_out];
		ch2=ch;
		if(ch2==0x07)ch2='.';
		printf("%02x '%c' ",ch,ch2);
	}
}
