#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "flashfnc.h"
#include "reads2.h"
#include "super.h"

int reads2(void)
{
	char buf[201],name[80],ch;
	int num_bytes,i,p,done=0,tries,ret_val;
	long start_addr;
	unsigned char checksum,value;
	FILE *fi;

	printf("Enter filename to read:");
	gets(name);
	fi=fopen(name,"r");
	if(fi==NULL)
	{
		printf("can't open it, sorry.\n");
		return(0);
	}

	fgets(buf,200,fi);
	while(!done)
	{
		/* read len */  /* 3 bytes are addr, 1 byte is checksum */
		num_bytes = (16*hex_to_int(buf[2])+hex_to_int(buf[3]))-4;

		/* read addr */
		start_addr=0;
		for(p=4,i=0;i<6;i++)
			start_addr = (start_addr<<4) + hex_to_int(buf[p++]);

		/* read/program data */
		for(i=0;i<num_bytes;i++)
		{
			value = 16*hex_to_int(buf[p++])+hex_to_int(buf[p++]);

			tries=0;
			do
			{
				ret_val=flash_write(start_addr+i,value);
				if(ret_val==0)
				{
					printf("\nfailed.  retry #%d.\n",++tries);
//					ch=getch();
//					if(ch=='q')return(0);
					empty_recv_buffer();
				} else
				{
					tries=0;
				}
			} while((tries<6) && (ret_val==0));

			if(tries!=0)
			{
				printf("\nfailure to successfully program byte.\n");
				while(!kbhit());
				ch=getch();
				if(ch=='q')return(0);
			}
			printf(".");
		}

		/* check for ending */
		if(!strncmp("S9",buf,2))
		{
			printf("Okay----finished programming\n");
			break;   /* done */
		}
		fgets(buf,200,fi);
		if(feof(fi))done=1;
	}
	printf("done programming.\n");
	fclose(fi);
	return(1);
}

int flash_write(long addr,unsigned char data)
{
	int t;
	char ch;
	int yy,zz;

	printf("writing 0x%02x to %08lx.\n",data,addr);

	if(setADDR(addr)==0)return(0);
	if(writeflashbyte(data)==0)return(0);
	if(verify_flash_read(data)==0)return(0);

	for(t=0;t<30000;t++);
	return(1);
}


int verifys2(void)
{
	char buf[201],name[80],ch;
	int num_bytes,i,p,done=0,tries,ret_val;
	long start_addr;
	unsigned char checksum,value;
	FILE *fi;

	printf("Enter filename to read:");
	gets(name);
	fi=fopen(name,"r");
	if(fi==NULL)
	{
		printf("can't open it, sorry.\n");
		return(0);
	}

	fgets(buf,200,fi);
	while(!done)
	{
		/* read len */  /* 3 bytes are addr, 1 byte is checksum */
		num_bytes = (16*hex_to_int(buf[2])+hex_to_int(buf[3]))-4;

		/* read addr */
		start_addr=0;
		for(p=4,i=0;i<6;i++)
			start_addr = (start_addr<<4) + hex_to_int(buf[p++]);

		/* read/program data */
		for(i=0;i<num_bytes;i++)
		{
			value = 16*hex_to_int(buf[p++])+hex_to_int(buf[p++]);

			tries=0;
			do
			{
				ret_val=flash_verify(start_addr+i,value);
				if(ret_val==0)
				{
					printf("\nfailed.  retry #%d.\n",++tries);
					empty_recv_buffer();
				} else
				{
					tries=0;
				}
			} while((tries<6) && (ret_val==0));

			if(tries!=0)
			{
				printf("\nfailure to successfully program byte.\n");
				while(!kbhit());
				ch=getch();
				if(ch=='q')return(0);
			}
			printf(".");
		}

		/* check for ending */
		if(!strncmp("S9",buf,2))
		{
			printf("Okay----finished programming\n");
			break;   /* done */
		}
		fgets(buf,200,fi);
		if(feof(fi))done=1;
	}
	printf("done programming.\n");
	fclose(fi);
	return(1);
}

int flash_verify(long addr,unsigned char data)
{
	int t;
	char ch;

	printf("checking for 0x%02x at %08lx.\n",data,addr);


	if(setADDR(addr)==0)return(0);
	if(verify_flash_read(data)==0)return(0);

	for(t=0;t<30000;t++);
	return(1);
}
