/* Infinitely expandable music generator 
   Shifty Death Effect done by Noah Vawter, around the middle of June,
   while replacing a head gasket */
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

typedef struct Pat {
  int notes[4][64];  /* 4 voices - 64 positions 
                        0 = nuddin.
                        1  thru 12, c-1 thru b-1
                        13 thru 24, c-2 thru b-2
                        25 thru 36, c-3 thru b-3 */
  } pat;
int no_pat;  /* the number of patterns */
int pattab[127];   /* the pattern table */
pat mast[1];
int ch[4];
int minor[]={ 0, 2, 3, 5, 7, 8,10,
             12,14,15,17,19,20,22,
             24,26,27,29,31,32,34};
int major[]={ 0, 2, 4, 5, 7, 9,11,
             12,14,16,17,19,21,23,
             24,26,28,29,31,33,35};
int key;
int *mode;
int retcho(int);
int retbas(int);
void output(void);
void chords(void);
void bass(void);
void main(void){
  int a,b,c,d; /* some generic counters... */  
  float fl;
  int four;
  int strict;
  char buf[200];
  
  strict=rand()%2;
  strict+=strict;

  /* sort of fize this */
  printf("hit some random keys:");
  scanf("%s",buf);
  b=0;
  for (a=0;a<(strlen(buf)-1);a++){
    b=b+(unsigned int)buf[a];}
  if (b<0)b=-b;
  srand(b);

  printf("o.k., picking chord progression\n");
  
  no_pat=1;  /* for now */
  
  /* pick mode */
  mode = minor;
  if(rand()%100 > 50) mode=major;

  chords();
  bass();
  output();
}

void bass(void){
  int pat[9][16]={
      1,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
      1,0,0,0, 1,0,0,0, 1,0,0,0, 1,0,0,0,
      1,0,0,0, 0,0,0,0, 0,0,0,0, 1,0,0,0,
      1,0,1,0, 1,0,1,0, 1,0,1,0, 1,0,1,0,
      1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1,
      1,0,0,0, 1,0,0,0, 0,0,0,0, 1,0,1,0,
      1,0,1,0, 1,0,0,0, 1,0,1,0, 1,0,0,0,
      1,0,0,0, 0,1,0,0, 0,0,1,0, 1,0,0,0,
      1,0,1,0, 1,0,0,0, 1,0,0,0, 1,0,1,0};
  int ba[4];
  int a,b;
  ba[0]=rand()%9;
  for(a=1;a<4;a++){
    ba[a]=retbas(ba[a-1]);}
  printf("bass patterns:\n");
  for(a=0;a<4;a++){
    printf("%d ",ba[a]);}
  printf("\n");

  /* fill in the one's with root notes */
  for(a=0;a<4;a++){
    for(b=0;b<16;b++){
      mast[0].notes[0][a*16+b]=0;
      if(pat[ba[a]][b]==1)
        mast[0].notes[0][a*16+b]=1+mode[ch[a]];
    printf("%d ",mast[0].notes[0][a*16+b]);
    }
    printf("\n");
  }
}

void chords(void){
  int a;
  int pat[7][4]={0,0,0,0,
                 0,1,2,3,
                 0,0,1,1,
                 0,0,0,1,
                 0,1,0,2,
                 0,1,0,1,
                 0,1,2,1};
  int te[4];
  int four;
  /* now to pick the chord(s) */
  four=rand()%7;
  for(a=0;a<4;a++)printf("%d ",pat[four][a]);
  printf("\n");
  te[0]=0;    /* first chord is the tonic */
  for(a=1;a<4;a++){  
    te[a]=retcho(a-1);}
  for(a=0;a<4;a++){
    ch[a]=te[pat[four][a]];}
  for(a=0;a<4;a++){
    printf("%d ",ch[a]+1);}
  printf("\n");
}
        
int retcho(int p){           
  int com[7][6]={4,5,6,7,2,3,
                 5,4,6,7,1,3,
                 6,4,7,1,2,5,
                 5,1,2,7,3,6,
                 1,4,6,7,2,3,
                 2,5,3,7,4,1,
                 1,3,6,2,4,5};
  int l=0;
  int done=0;

  while(!done){
    if (rand()%100 < 20){
      done=1;
      return(com[p][l]-1);
    }
    if(l==5){
      done=1;
      return(com[p][rand()%6]-1);
    }
    l++;
  }
  return(99);
}

int retbas(int p){
  int next[9][4]={1,1,0,0,
                  0,0,1,1,
                  1,0,0,0,
                  0,1,1,0,
                  0,0,1,0,
                  1,0,0,1,
                  1,1,0,0,
                  0,0,0,1,
                  0,1,0,1};
  int r,a;
  int done=0;
  while(!done){
    r=rand()%9;
    for(a=0;a<4;a++){ 
      if(next[p][a]==1 && next[r][a]==1){ 
        return(r);
      }
    }
  }
}

void output(void){
  FILE *fi;
  int a,b,c,d;
  int b1,b2,b3,b4;
  float fl;
  int tuning[37]={000,
                  856,808,762,720,678,640,604,570,538,508,480,453,
                  428,404,381,360,339,320,302,285,269,254,240,226,
                  214,202,190,180,170,160,151,143,135,127,120,113};

  /* now to output it! */
  /* open output file */
  fi=fopen("mod.mod","w");
  if(fi==NULL)
    {printf("Psychedlic Dan!\n");exit(-1);}
  
  /* put in title */
  fprintf(fi,"hmmm");
  
  for(a=0;a<16;a++)
    fputc('\0',fi);

  /* put in samples */
  for(a=0;a<31;a++){
    if(a==0){
      fprintf(fi,"tingly");    /* name */
      for(b=0;b<16;b++)fputc('\0',fi);  /* pad name */
      fprintf(fi,"%c%c",2,0);  /* length */
    } else {
      for(b=0;b<22;b++)fputc('\0',fi);   /* pad name */
      fprintf(fi,"%c%c",0,0);  /* length */
    }
    fprintf(fi,"%c",0);      /* fine-tune */
    fprintf(fi,"%c",0x40);   /* volume */
    fprintf(fi,"%c%c",0,0);    /* rep point */
    fprintf(fi,"%c%c",0,1);    /* rep pos */
  }
 
  /* now the pattern-type stuff */
  fprintf(fi,"%c",3);  /* songlength */
  fprintf(fi,"%c",127);  /* for some crazy reason */

  /* master pattern table */
  for(a=0;a<128;a++){
    if(a==0){
      fprintf(fi,"%c",0);
    } else {
      fprintf(fi,"%c",0);
    }
  }

  fprintf(fi,"M.K.");   /* those two dudes. */

  /* now for the pattern(s) */
  for (a=0;a<no_pat;a++){  /* the pattern */
    for (b=0;b<64;b++){    /* the position in the pattern */
      for (c=0;c<4;c++){   /* the voice number! */
 /*
 _____byte 1_____   byte2_    _____byte 3_____   byte4_
/                 /        /                 /      
0000          0000-00000000  0000          0000-00000000
Upper four    12 bits for    Lower four    Effect command.
bits of sam-  note period.   bits of sam-
ple number.                  ple number. */
        b1=0;
        b4=0;
        if(c==0){
          d=((tuning[mast[0].notes[c][b]])&3840)/256; /* upper four bits */
          d=d&15;   /* mask 'em out...just in case */
          b1=b1+d;
          b2=tuning[mast[0].notes[c][b]]&255;  /* mask lower bits */
          b3=1*16+0;
        } else {
          b2=0;
          b3=0;
        }
        fprintf(fi,"%c%c%c%c",b1,b2,b3,b4);
      }
    }
  }

  /* now for the sample(s) */
  for (a=0;a<1024;a++){
    fl=(float)a/4;
    b=128+128*sin(fl);
    b=b*(1024-(float)a/1024);
    fputc(b-128,fi);
  }

  /* I think that's all! */
  fclose(fi);   /* oopsss!!! */
}
