#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include "super.h"
#include "flashfnc.h"


/* global data */
unsigned char Channel,ContNumb,Value;



void erase_sector(void)
{
	int sect;
	char buf[80];
	printf("Enter sector to erase (0-7):\n");
	gets(buf);
	sect=atoi(buf);

	Channel  = 0;
	ContNumb = 56;
	Value    = sect;

	send_cont(Channel,ContNumb,Value);
}

void set_addr(void)
{
	char buf[80],*buf_p;
	int i,addr_val;

	printf("set addr.\n");
	printf("Enter new address:  (8 hex digits)");
	gets(buf);
	for(buf_p=&buf[0],i=0;i<4;i++)
	{
		addr_val =16*hex_to_int(*buf_p++);
		addr_val+=   hex_to_int(*buf_p++);

		Channel  = 0;
		ContNumb = 53-i;
		Value    = addr_val;

		send_cont(Channel,ContNumb,addr_val);
	}
}

void read_flash_byte(void)
{
	printf("Read a Byte-------------\n");

	Channel  = 0x0;
	ContNumb = 54;
	Value    = 0x0;

	send_cont(Channel,ContNumb,Value);
}

void write_flash_byte(void)
{
  char buf[80];
	int data_val;

	printf("Write a Byte-------------\n");
	printf("Enter an 8-bit data value to write at ADDR:");
	gets(buf);

	data_val = 16*hex_to_int(buf[0]);
	data_val+=    hex_to_int(buf[1]);

	/* send set_data_byte */
	Channel  = 0;
	ContNumb = 0x3b;
	Value    = data_val;
	send_cont(Channel,ContNumb,Value);

	/* send read_data_byte */
	Channel  = 0;
	ContNumb = 0x3c;
	Value    = 0xff;
	send_cont(Channel,ContNumb,Value);

	/* send enable write */
	Channel  = 0;
	ContNumb = 0x37;
	Value    = 0x23;
	send_cont(Channel,ContNumb,Value);
}

void print_addr(void)
{
	printf("Print ADDR Reg (cont. 58)------\n");

	Channel  = 0x00;
	ContNumb = 58;
	Value    = 0x00;

	send_cont(Channel,ContNumb,Value);
}




void send_cont(unsigned char chan,unsigned char cont,unsigned char val)
{
	uputc( 0xB0|chan);slow();
	uputc(      cont);slow();
	uputc(       val);slow();
}

int hex_to_int(char x)
{
	x=toupper(x);

	if( x>= '0' && x<= '9') return(x-'0');
	return(10+(x-'A'));
}

void print_func_help(void)
{
	printf("F1 = send a.            \n");
	printf("F2 = erase sector.      \n");
	printf("F3 = set ADDR reg.      \n");
	printf("F4 = read byte @ ADDR.  \n");
	printf("F5 = print ADDR.        \n");
	printf("F6 = write byte @ ADDr. \n");
}


int setADDR(long the_addr)
{
	int i;
	unsigned char recbuf[4];
	int errorset;
	long addr_val;

	for(i=0;i<4;i++)
	{
		addr_val = ( (the_addr)>>((3-i)*8) )&0xff;
		Channel  = 0;
		ContNumb = 53-i;
		Value    = addr_val;
		send_cont(Channel,ContNumb,Value);

		/* verify transmission */
		errorset=0;
		if(recv_data(&recbuf[0],3)==0)errorset=1;
		if(recbuf[0]!=      0x10)errorset=2;
		if(recbuf[1]!=  ContNumb)errorset=3;
		if(recbuf[2]!=  addr_val)errorset=4;
		if(errorset!=0)
		{
			printf("Error sending setADDR command: step %d.\n",errorset);
			empty_recv_buffer();
			return(0);
		}
	}
	return(1);
}

int writeflashbyte(unsigned char data_val)
{
	int errorset;
	unsigned char recbuf[10];

	if(send_set_data(data_val)==0)return(0);
	if(verify_set_data(data_val)==0)return(0);
	if(enable_write()==0)return(0);

	return(1);
}

int send_set_data(unsigned char data_val)
{
	int errorset;
	unsigned char recbuf[10];

	Channel  = 0;
	ContNumb = 59;
	Value    = data_val;

	send_cont(Channel,ContNumb,Value);

	/* verify transmission */
	errorset=0;
	if(recv_data(&recbuf[0],3)==0)errorset=1;
	if(recbuf[0]!=      0x10)errorset=2;
	if(recbuf[1]!=  ContNumb)errorset=3;
	if(recbuf[2]!=     Value)errorset=4;

	if(errorset!=0)
	{
		printf("Error sending set_data command: step %d.\n",errorset);
		empty_recv_buffer();
		return(0);
	}
	return(1);
}


int verify_set_data(unsigned char data_val)
{
	int errorset;
	unsigned char recbuf[10];

	Channel  = 0;
	ContNumb = 60;
	Value    = data_val;   // don't care

	send_cont(Channel,ContNumb,Value);

	/* verify transmission */
	errorset=0;
	if(recv_data(&recbuf[0],4)==0)errorset=1;
	if(recbuf[0]!=      0x10)errorset=2;
	if(recbuf[1]!=  ContNumb)errorset=3;
	if(recbuf[2]!=     Value)errorset=4;
	if(recbuf[3]!=     Value)errorset=5;

	if(errorset!=0)
	{
		printf("Error sending verify_set_data command: step %d.\n",errorset);
		empty_recv_buffer();
		return(0);
	}
	return(1);
}

int enable_write(void)
{
	int errorset;
	unsigned char recbuf[10];

	Channel  = 0;
	ContNumb = 55;
	Value    = 0x23;   // don't care

	send_cont(Channel,ContNumb,Value);

	/* verify transmission */
	errorset=0;
	if(recv_data(&recbuf[0],3)==0)errorset=1;
	if(recbuf[0]!=      0x10)errorset=2;
	if(recbuf[1]!=  ContNumb)errorset=3;
	if(recbuf[2]!=     Value)errorset=4;
	if(errorset!=0)
	{
		printf("Error sending enable_write command: step %d.\n",errorset);
		empty_recv_buffer();
		return(0);
	}
	return(1);
}

int verify_flash_read(unsigned char data)
{
	int errorset=0;
	unsigned char recbuf[10];

	/* send flash read byte command */
	Channel  = 0x0;
	ContNumb = 54;
	Value    = 0x0;
	send_cont(Channel,ContNumb,Value);

	/* verify transmission */
	if(recv_data(&recbuf[0],4)==0)errorset=1;
	if(recbuf[0]!=      0x10)errorset=2;
	if(recbuf[1]!=  ContNumb)errorset=3;
	if(recbuf[2]!=     Value)errorset=4;
	if(recbuf[3]!=      data)errorset=5;

	printf("read: 0x%02x, looking for 0x%02x.\n",recbuf[3],data);
	if(errorset!=0)
	{
		printf("Error verifying flash byte: step %d.\n",errorset);
		empty_recv_buffer();
		return(0);
	}
	printf("\n");

	return(1);
}

void slow(void)
{
	int t,u;

	for(u=0;u<3;u++)for(t=0;t<30000;t++);
}

void EXprg(void)
{
	int sect,i;
	char buf[80];
	printf("Enter prg to load (1-7):\n");
	gets(buf);
	sect=atoi(buf);


	buf[0]='$';
	buf[1]='E';
	buf[2]='X';
	buf[3]=0x00;
	buf[4]=sect;

	for(i=0;i<5;i++)
	{
		uputc(buf[i]);
		slow();
	}
}

void RUprg(void)
{
	int sect,i;
	char buf[80];
	printf("Enter prg to load & run (1-7):\n");
	gets(buf);
	sect=atoi(buf);


	buf[0]='$';
	buf[1]='R';
	buf[2]='U';
	buf[3]=0x00;
	buf[4]=sect;

	for(i=0;i<5;i++)
	{
		uputc(buf[i]);
		slow();
	}
}

void GOprg(void)
{
	int sect,i;
	char buf[80];


	buf[0]='$';
	buf[1]='G';
	buf[2]='O';
	buf[3]=0x00;
	buf[4]=0x00;

	for(i=0;i<5;i++)
	{
		uputc(buf[i]);
		slow();
	}
}

void dumpbdma(void)
{
	setADDR(0x00000000); just_flash_read();
	setADDR(0x00004000); just_flash_read();
	setADDR(0x00008000); just_flash_read();
	setADDR(0x0000c000); just_flash_read();
	setADDR(0x00010000); just_flash_read();
	setADDR(0x00014000); just_flash_read();
	setADDR(0x00018000); just_flash_read();
	setADDR(0x00018000); just_flash_read();
}

int just_flash_read(void)
{
	int errorset=0;
	unsigned char recbuf[10];

	/* send flash read byte command */
	Channel  = 0x0;
	ContNumb = 54;
	Value    = 0x0;
	send_cont(Channel,ContNumb,Value);

	/* verify transmission */
	if(recv_data(&recbuf[0],4)==0)errorset=1;
	if(recbuf[0]!=      0x10)errorset=2;
	if(recbuf[1]!=  ContNumb)errorset=3;
	if(recbuf[2]!=     Value)errorset=4;
//	if(recbuf[3]!=      data)errorset=5;

//	printf("read: 0x%02x, looking for 0x%02x.\n",recbuf[3],data);
	if(errorset!=0)
	{
		printf("Error just reading flash byte: step %d.\n",errorset);
		empty_recv_buffer();
		return(0);
	}
	printf("\n");

	return(1);
}
