.module       MIDI;

.include    <system.k>;

.global process_midi,midi_vel,midi_val,midi_cont;
.external       handle_MIDI_controller;

{ incoming MIDI message results }
.var    midi_vel,               { MIDI velocity }
        midi_note,              { MIDI note }
        midi_cont,              { MIDI controller number }
        midi_val;               { MIDI controller value }

{ variables for the MIDI input state machine }
.var    inputmidi,              { MIDI input data from serial port }
        midi_status,midi_ch,    { MIDI Status, MIDI channel }
        midi_state,             { MIDI state machine }
        midi_data1,midi_data2,  { incoming midi data }
        midi_onnote;            { which note is actually being played ? }

.init midi_state:  0x0;
.init midi_status: 0x0;

process_midi:   

        { read incoming byte }
        i4 = dm (PTR_TO_GET_CHAR);call (i4);
        if lt jump end_proc_midi; { time out }

        dm(inputmidi) = ax1;
        ar = tstbit 7 of ax1;
        if ne jump MIDIstatus;

MIDIdata:
        { shift MIDI data in }
        ax0 = dm(midi_data2);
        dm(midi_data1) = ax0;
        dm(midi_data2) = ax1;

        ar  = dm(midi_state);   { if second data byte, handle MIDI mesg }
        none = pass ar;
        if ne jump MIDIevent;   

        ax1 = 1;                { wait for another byte }
        dm(midi_state)=ax1;
        jump end_proc_midi;

MIDIevent:
        ax1 = 0;                  { reset input data buffer }
        dm(midi_state)=ax1;

        ax1 = dm(midi_status);    { what kind of message is it? }

        ay0 = 0x0080;none = ax1 - ay0;if eq jump MIDInoteoff;
        ay0 = 0x0090;none = ax1 - ay0;if eq jump MIDInoteon;
        ay0 = 0x00b0;none = ax1 - ay0;if eq jump MIDIcontr;

        { ignore other types of messages (for now!) }
        jump end_proc_midi;

MIDIstatus:
        ay0 = 0xf0;               { check to see if it starts with 0xf0 }      
        ar  = ax1 and ay0;              
        ar  = ar - ay0;
        if eq jump MIDIrealtime;

        dm(midi_status)=ax1;      { set this as our new status }

        ay1 = 0x000f;    { compute midi channel number }
        ar  = ax1 and ay1;
        dm(midi_ch) = ar;               

        ax1 = 0;                  { initialize input data buffer }
        dm(midi_state)=ax1;

        jump end_proc_midi;


{ f0,f1,f2,f3,f4,f5,f6,f7,f8,f9,fa,fb,fc,fd,fe,ff }
MIDIrealtime:
        { don't do anything with these yet }

        ax1 = 0;                  { initialize input data buffer }
        dm(midi_state)=ax1;

        jump end_proc_midi;

{ handle MIDI Note on message --------------------------------------- }
MIDInoteon:         
        ax1 = dm(midi_data1);           { get midi_note number }
        dm(midi_note) = ax1;            { temp store }
        dm(midi_onnote) = ax1;          { long term store }

        ax1 = dm(midi_data2);           { get midi_vel value }
        dm(midi_vel) = ax1;

        call newsound;                  { yay }

        jump end_proc_midi;

{ handle MIDI Note Off message --------------------------------------- }
MIDInoteoff:
        ax1 = dm(midi_data1);           { get midi_note number }
        dm(midi_note) = ax1;

        { only kill sound if this note is actually playing }
        ay1 = dm(midi_onnote);
        ar  = ax1 - ay1;
        if ne jump end_proc_midi;

        ax1 = dm(midi_data1);           { get midi_vel value }
        dm(midi_vel) = ax1;

        call killsound;                 { update envelope status }

        jump end_proc_midi;

{ handle MIDI Control message ------------------------------------ }
MIDIcontr:

        ax1 = dm(midi_data1);           { save midi_cont number }
        dm(midi_cont) = ax1;

        ax1 = dm(midi_data2);           { save midi_val value }
        dm(midi_val) = ax1;

        { jump to appropriate routine for controller type }
        ax1 = dm(midi_cont);
        call handle_MIDI_controller;

end_proc_midi:
        rts;


{ remove a sound from the sound queue ---------------------------------- }
killsound:
        rts;


{ Use MIDI note number.....euh ---------------------------- }
newsound:
        ax1 = dm(midi_ch);
        rts;

note_as_mod_delta:
        ax1 = dm(midi_note);             { Look up 8.8 delta for note number }
        rts;

note_as_pitch_scale:
        ax1 = dm(midi_note);
        rts;

.endmod;

